package jp.co.sample.common;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sample.exception.ApplicationException;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.chain.commands.InvalidPathException;
import org.apache.struts.config.ExceptionConfig;

public class SysExceptionHandler extends ExceptionHandler {

	/** logger */
	private static Logger logger = Logger.getLogger(SysExceptionHandler.class);

	/**
	 * @see org.apache.struts.action.ExceptionHandler#execute(java.lang.Exception,
	 *      org.apache.struts.config.ExceptionConfig, org.apache.struts.action.ActionMapping,
	 *      org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public ActionForward execute(Exception e, ExceptionConfig config, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws ServletException {

		ActionForward forward = null;
		ActionMessage message = null;

		if (e instanceof ApplicationException) {
			// アプリケーションエラーの場合

			ApplicationException appException = (ApplicationException) e;

			// メッセージキー
			String messageKey = appException.getMessageKey();
			// メッセージ引数
			String[] messageArgs = appException.getMessageArgs();

			// アクションエラー
			if (messageArgs == null || messageArgs.length <= 0) {
				message = new ActionMessage(messageKey);
			} else {
				message = new ActionMessage(messageKey, messageArgs);
			}

			// フォワード
			forward = mapping.getInputForward();
			if (forward == null) {
				forward = new ActionForward(config.getPath());
			}
		} else if (e instanceof InvalidPathException) {
			// stutsのアクションが見つからない場合、ステータスコード404を返す
			logger.error("InvalidPathException. path = " + ((InvalidPathException) e).getPath());
			try {
				response.sendError(HttpServletResponse.SC_NOT_FOUND);
			} catch (Exception e2) {
				throw new ServletException(e2);
			}
			
		} else {
			// その他例外
			logger.error("Exception", e);

			message = new ActionMessage(config.getKey());
			forward = new ActionForward(config.getPath());
		}

		if (logger.isDebugEnabled()) {
			logger.debug("Exception", e);
		}

		// 例外を格納
		storeException(request, config.getKey(), message, forward, config.getScope());

		return forward;
	}

}
