package jp.co.sample.common;

import javax.servlet.http.HttpServletRequest;

import jp.co.sample.bean.LoginInfo;

/**
 * セッション管理を行うためのクラス。
 * 
 * @author 生地 真規
 */
public class SessionAccessor {

	/** 同期処理用の変数 */
	private static final byte[] MUTEX = new byte[0];

	/** 当クラスの唯一のオブジェクト。 */
	private static SessionAccessor obj;
	
	/** プライベートコンストラクタ */
	private SessionAccessor() {

	}

	/**
	 * 当クラスのオブジェクトを取得します。
	 * 
	 * @return SessionAccessorオブジェクト
	 */
	public static SessionAccessor getInstance() {

		if (obj == null) {
			synchronized (MUTEX) {
				if (obj == null) {
					obj = new SessionAccessor();
				}
			}
		}
		return obj;
	}

	/**
	 * セッションからログイン情報を取得します。
	 * 
	 * @param request リクエスト
	 * @return ログイン情報
	 */
	public LoginInfo getLoginInfo(HttpServletRequest request) {

		return (LoginInfo) request.getSession().getAttribute(LoginInfo.LOGIN_INFO_KEY);
	}

	/**
	 * セッションにログイン情報を設定します。
	 * 
	 * @param requset リクエスト
	 * @param loginInfo ログイン情報
	 */
	public void setLoginInfo(HttpServletRequest request, LoginInfo loginInfo) {

		request.getSession().setAttribute(LoginInfo.LOGIN_INFO_KEY, loginInfo);
	}

	/**
	 * セッションからログイン情報を除去します。
	 * 
	 * @param request リクエスト
	 */
	public void removeLoginInfo(HttpServletRequest request) {

		setLoginInfo(request, null);
	}

	/**
	 * セッションにアトリビュートを追加します。
	 * @param request リクエスト
	 * @param name 名前
	 * @param obj 格納オブジェクト
	 */
	public void addAttribute(HttpServletRequest request, String name, Object val) {
		request.getSession().setAttribute(name, val);
	}
	
	/**
	 * セッションからアトリビュートを除去します。
	 * @param request
	 * @param name 名前
	 */
	public void removeAttribute(HttpServletRequest request, String name) {
		request.getSession().setAttribute(name, null);
	}
	
	/**
	 * セッションからアトリビュートを取得します。
	 * @param request
	 * @param name 名前
	 */
	public Object getAttribute(HttpServletRequest request, String name) {
		return request.getSession().getAttribute(name);
	}

}
