package jp.co.sample.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sample.bean.LoginInfo;
import jp.co.sample.common.SessionAccessor;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

/**
 * アクションクラスの抽象クラス。 各画面のアクション処理は当メソッドよりテンプレートメソッド経由で呼び出される。
 * 
 * @author 生地　真規
 * 
 */
public abstract class BaseAction extends ActionSupport {

	/** logger */
	private static Logger logger = Logger.getLogger(BaseAction.class);
	
	protected static final String FORWORD_SUCCESS = "success";

	/**
	 * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
	 *      org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// フォワード名
		String foward = null;
		
		// 各アクション処理実行
		foward = mainProcess(mapping, form, request, response);

		// トークンの保存
		this.saveToken(request);
		
		if (foward != null) {
			return mapping.findForward(foward);
		}	
		
		return null;
		
	}
	
	/**
	 * 各画面処理抽象メソッド。 各Actionクラスでは当メソッドを実装しする。
	 * 
	 * @param mapping アクションマッピング
	 * @param form フォーム
	 * @param request リクエスト
	 * @param response レスポンス
	 * @return フォワード名
	 * @exception アクションで発生した例外
	 */
	protected abstract String mainProcess(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) throws Exception;

	/**
	 * セッションからログイン情報を取得します。
	 * 
	 * @param request リクエスト
	 * @return ログイン情報
	 */
	protected LoginInfo getLoginInfo(HttpServletRequest request) {
		return SessionAccessor.getInstance().getLoginInfo(request);
	}

	/**
	 * applicationContextに設定されているロジックを取得します。
	 * @param geanName
	 * @return
	 */
	protected Object getLogic(String geanName) {
		return getWebApplicationContext().getBean(geanName);
	}
	
}
